// Filter Sunkissed
__kernel void filter_Sunkissed(__read_only image2d_t image,   		// input image
							   __global uchar* clipTable,			// image buffer clip table
							   __write_only image2d_t retImage,   	// image result
							   __private int addR,
							   __private int addG,
							   __private int addB,
							   __private int alpha)	 				// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);

	if(w >= width || h >= height)
			return;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;

	uchar4 color = convert_uchar4(read_imagef(image, sampler, (int2)(w, h)) * 255.0f);
	uchar4 retColor;
	int Y = (7450 * color.z + 38442 * color.y + 19668 * color.x + 65535) >> 8;
	
	int index_R = (Y + addR) >> 8;
	int index_G = (Y + addG) >> 8;
	int index_B = (Y + addB) >> 8;
	
	if(index_R < 0)	index_R = 0;
	else if(index_R > 511)	index_R = 511;
		
	if(index_G < 0)	index_G = 0;
	else if(index_G > 511)	index_G = 511;
		
	if(index_B < 0)	index_B = 0;
	else if(index_B > 511)	index_B = 511;
		
	retColor.x = clipTable[index_R];
	retColor.y = clipTable[index_G];
	retColor.z = clipTable[index_B];		
	retColor.w = color.w;
	
	float factor = (float)(alpha)/100.0f;
	float4 ret = (convert_float4(retColor) * factor + (1.0f - factor) * convert_float4(color)) / 255.0f;
	
	write_imagef(retImage, (int2)(w, h), ret);
}